const express = require("express");
const router = express.Router();
const { GlobalInsert } = require("../../GlobalFunctions/GlobalCreate");
const { GlobalUpdate } = require("../../GlobalFunctions/GlobalUpdate");
const tableName = require("../../Utils/allTableNames");

router.post("/updateEmailConfiguration", (req, res) => {
  try {
    if (!req.body.id || !req.body.email || !req.body.area || !req.body.machine || !req.body.shift) {
      return res.status(400).send(RESPONSE(false, "Please Fill All fields", {}));
    } 
    else {
      let payload = {
        id: req.body.id,
        tableName: tableName.emailConfiguration,
        databaseFields: {
          email: req.body.email,
          area: req.body.area,
          machine: req.body.machine,
          shift: req.body.shift
        },
      };
      GlobalUpdate(payload, res);
    }
  } catch (error) {
    return res.send(RESPONSE(false, "Email Configuration Insert (Catch Error)", {}));
  }
});

module.exports = router;
