var express = require("express");
const { GlobalInsert } = require("../../GlobalFunctions/GlobalCreate");
const router = express.Router();
const tableNames = require("../../Utils/allTableNames");

router.post("/createCenterlineItems", (req, res) => {
  let payload = {
    tableName: tableNames.centerlineItems,
    databaseFields: {
      centerlineId: req.body.centerlineId,
      centerlineName: req.body.centerlineName,
      targetValue: req.body.targetValue,
      minimumValue: req.body.minimumValue,
      maximumValue: req.body.maximumValue,
      units: req.body.units,
      frequency: req.body.frequency,
      status: req.body.status,
      qualityCritical: req.body.qualityCritical,
      safetyCritical: req.body.safetyCritical,
      date: req.body.date,
      time: req.body.time
    },
  };
  GlobalInsert(payload, res);
});

module.exports = router;
