const pool = require("../Utils/db");
const response = require("../GlobalResponse/RESPONSE");
const tableNames = require("../Utils/allTableNames");
const moment = require('moment-timezone');
const poolFl = require("../Utils/dbFl");
const frequencies = require("../Functions/frequencies");
const cronDataCenterlineItems = require("../Functions/cronDataCenterlineItems")

const cronJobCenterlineItems = async (req, res) => {

    try {
        console.log("Centerline Items Cron Job Started");
        const karachiTime = moment().tz('Asia/Karachi');
        // Separate the date and time
        const currentDate = karachiTime.format('YYYY-MM-DD');
        const currentTime = karachiTime.format('HH:mm');
        console.log("Current Date in Karachi:", currentDate);
        console.log("Current Time in Karachi:", currentTime);
        // const currentTimeArray = currentTime.split(":");
        // const currentHour = currentTimeArray[0];
        // // const currentHour = "08";
        // console.log("Cuurent Hour: ", currentHour);

        const dayOfWeek = karachiTime.format('dddd');

        // if (currentTime === "15:53") {
        if (dayOfWeek !== "Sunday") {
        // if (currentTime === "17:24") {
            // console.log("In CL ITEM cronjob")

            pool.getConnection((err, connection) => {
                if (err) {
                    console.log("eror while creating connection", err);
                    // return res.send(response(false, "database error", {}));
                } else {
                    connection.query(`SELECT * FROM ${tableNames.centerlineItems} where status = 1`, (err, result) => {
                        connection.release();
        
                        if (err) {
                            // // console.log("database");
                            console.log(err);
                            // return res.send(response(false, "error while inserting", {}));
                        } else {
                            // console.log("Result: ", result); 
                            // return res.send(response(true, "succesfully added", result));
                            if (result.length > 0) {
                                result.forEach(item => {
                                    console.log("Item: CL I", item);
                                    if (item.dateToUpdate == currentDate) {
                                        // if (item.time == currentTime && item.dateToUpdate == currentDate) {
                                            // Modify the record as needed before inserting
                                            item.centerlineItemId= item.id;
                                            // item.userStatus=0;
                                            let newid=item.id;
                                            delete item.id;
                                            item.date = currentDate;
                                            if (item.frequency === frequencies.daily) {                                            
                                                item.dateToUpdate = moment.tz(item.dateToUpdate, 'Asia/Karachi');
                                                item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                                if (item.dateToUpdate.day() === 0) {
                                                    item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                                }
                                                item.dateToUpdate = item.dateToUpdate.format('YYYY-MM-DD');
                                                cronDataCenterlineItems(item, newid, currentDate);
                                            } else if (item.frequency === frequencies.weekly) {
                                                item.dateToUpdate = moment.tz(item.dateToUpdate, 'Asia/Karachi');
                                                item.dateToUpdate = item.dateToUpdate.add(1, 'weeks');
                                                if (item.dateToUpdate.day() === 0) {
                                                    item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                                }
                                                item.dateToUpdate = item.dateToUpdate.format('YYYY-MM-DD');
                                                cronDataCenterlineItems(item, newid, currentDate);
                                            } else if (item.frequency === frequencies.biweekly) {
                                                item.dateToUpdate = moment.tz(item.dateToUpdate, 'Asia/Karachi');
                                                item.dateToUpdate = item.dateToUpdate.add(2, 'weeks');
                                                if (item.dateToUpdate.day() === 0) {
                                                    item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                                }
                                                item.dateToUpdate = item.dateToUpdate.format('YYYY-MM-DD');
                                                cronDataCenterlineItems(item, newid, currentDate);
                                            } else if (item.frequency === frequencies.monthly) {
                                                item.dateToUpdate = moment.tz(item.dateToUpdate, 'Asia/Karachi');
                                                item.dateToUpdate = item.dateToUpdate.add(1, 'months');
                                                if (item.dateToUpdate.day() === 0) {
                                                    item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                                }
                                                item.dateToUpdate = item.dateToUpdate.format('YYYY-MM-DD');
                                                cronDataCenterlineItems(item, newid, currentDate);
                                            } else if (item.frequency === frequencies.quaterly) {
                                                item.dateToUpdate = moment.tz(item.dateToUpdate, 'Asia/Karachi');
                                                item.dateToUpdate = item.dateToUpdate.add(4, 'months');
                                                if (item.dateToUpdate.day() === 0) {
                                                    item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                                }
                                                item.dateToUpdate = item.dateToUpdate.format('YYYY-MM-DD');
                                                cronDataCenterlineItems(item, newid, currentDate);
                                            } else if (item.frequency === frequencies.yearly) {
                                                item.dateToUpdate = moment.tz(item.dateToUpdate, 'Asia/Karachi');
                                                item.dateToUpdate = item.dateToUpdate.add(1, 'years');
                                                if (item.dateToUpdate.day() === 0) {
                                                    item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                                }
                                                item.dateToUpdate = item.dateToUpdate.format('YYYY-MM-DD');
                                                cronDataCenterlineItems(item, newid, currentDate);
                                            } else {
                                                
                                            }
                                        } 
                                });
                            } else {
                                console.log('No records found with frequency.');
                            }
                        }
                    });
                }
            });
        } else {
            console.log("Today is Sunday");
        }
        console.log("Centerline Item Cron Job Completed");
    } catch (err) {
    console.log("Cron Job Centerline Item (Catch): ", err.message);
    }
};

module.exports = { cronJobCenterlineItems };


