const express = require("express");
const cors = require("cors");
const morgan = require("morgan");
const http = require("http");
const app = express();
const fileUpload = require('express-fileupload');
const rateLimit = require('express-rate-limit');
const helmet = require('helmet');
const cron = require("node-cron");
const { cronJobCenterline } = require("./middleware/cronJobCenterline");
const { cronJobCenterlineItems } = require("./middleware/cronJobCenterlineItems");
const { cronJobTimeout } = require("./middleware/cronJobTimeout");
const { cronJobCenterlineShiftly } = require("./middleware/cronJobCenterlineShiftly")
const { cronJobCenterlineItemsShiftly } = require("./middleware/cronJobCenterlineItemsShiftly")
const { cronJobSingle } = require("./middleware/cronJobSingle");
const moment = require('moment-timezone');



const appRouter = require("./routes");

app.use(cors());
app.use(morgan("dev"));
app.use(express.urlencoded({ extended: false }));
app.use(express.json({ extended: false }));
app.use(express.json());
app.use(express.static("public"));
app.use(fileUpload({ safeFileNames: true, preserveExtension: true }));

const limiter = rateLimit({
	windowMs: 5 * 60 * 1000, // 15 minutes
	limit: 50, // Limit each IP to 100 requests per `window` (here, per 15 minutes).
  message: "you have exceed the number of request"
});

app.use(helmet());

// Apply the rate limiting middleware to all requests.
app.use(limiter);

app.use("/uploads", express.static("uploads"));
app.use("/uploads/images", express.static("uploads/images"));

app.get("/", (req, res) => {
  res.send(`Success ${moment().tz('Asia/Karachi')}`);
});

app.use("/", appRouter)


// ADD CALL to execute your function(s)
// scheduledFunctions.initScheduledJobs();
// Cron Job For Centerline 

// cron.schedule("* * * * *", shiftlyJobForCenterline); // Runs every minute
// cron.schedule("0 * * * *", shiftlyJobForCenterline); // Runs every one hour
// cron.schedule("0 8 * * *", insertOtherFrequenciesFeedback); // Runs at 8 AM
// cron.schedule("* * * * *", insertOtherFrequenciesFeedback); // Runs every minute

// Cron Job For Centerline Items

// cron.schedule("* * * * *", shiftlyJobForCenterlineItems); // Runs at 2 sec
//cron.schedule("0 * * * *", shiftlyJobForCenterlineItems); // Runs every one hour
//cron.schedule("0 8 * * *", insertOtherFrequenciesFeedbackItems); // Runs at 21:05
// cron.schedule("* * * * *", insertOtherFrequenciesFeedbackItems); // Runs at 21:05

// Cron Job For Timeout
// cron.schedule("* * * * *", cronJobTimeout); // Runs at 2 sec
// cron.schedule("0 * * * *", cronJobTimeout); // Runs every one hour

// Actual 1
// const cronJobScheduleCenterline = cron.schedule("0 8 * * *", cronJobCenterline); 
// const cronJobScheduleCenterlineItems = cron.schedule("1 8 * * *", cronJobCenterlineItems); 

// Test 1
// const cronJobScheduleCenterline = cron.schedule("33 14 * * *", cronJobCenterline); 
// const cronJobScheduleCenterlineItems = cron.schedule("36 14 * * *", cronJobCenterlineItems); 

// Actual 2
// const cronJobScheduleShiftlyCenterline = cron.schedule("2 * * * *", cronJobCenterlineShiftly); 
// const cronJobScheduleShiftlyCenterlineItems = cron.schedule("3 * * * *", cronJobCenterlineItemsShiftly);

// Test 2
// const cronJobScheduleShiftlyCenterline = cron.schedule("12 15 * * *", cronJobCenterlineShiftly); 
// const cronJobScheduleShiftlyCenterlineItems = cron.schedule("13 15 * * *", cronJobCenterlineItemsShiftly);

// Actual 3
// const cronJobScheduleTimeout = cron.schedule("4 * * * *", cronJobTimeout);

// Test 3
// const cronJobScheduleTimeout = cron.schedule("5 * * * *", cronJobTimeout);
const cronJobScheduleSingle = cron.schedule("*/1 * * * 1,2,3,4,5,6", cronJobSingle);       



// cronJobScheduleCenterline.start();
// cronJobScheduleCenterlineItems.start();

// cronJobScheduleShiftlyCenterline.start();
// cronJobScheduleShiftlyCenterlineItems.start();

// cronJobScheduleTimeout.start();
cronJobScheduleSingle.start();


const server = http.createServer(app);
const PORT = process.env.PORT || 5000;
server.listen(PORT, () => {
  console.log(`Server is running on: localhost:`, PORT);
});
