const express = require("express");
const router = express.Router();
const tableName = require("../../Utils/allTableNames");
const { GlobalInsert } = require("../../GlobalFunctions/GlobalCreate");
const RESPONSE = require("../../GlobalResponse/RESPONSE");

router.post("/createUnits", (req, res) => {
  if (!req.body.units) {
    return res.status(400).send(RESPONSE(false, "Please Fill All fields", {}));
  }
  let payload = {
    tableName: tableName.units,
    databaseFields: {
      units: req.body.units,
    },
  };
  GlobalInsert(payload, res);
});

module.exports = router;
