const express = require("express");
const router = express.Router();
const { GlobalUpdate } = require("../../GlobalFunctions/GlobalUpdate");
const tableName = require("../../Utils/allTableNames");

router.post("/updateCenterlineItems", (req, res) => {
  let payload = {
    id: req.body.id,
    tableName: tableName.centerlineItems,
    databaseFields: {
      centerlineName: req.body.centerlineName,
      targetValue: req.body.targetValue,
      minimumValue: req.body.minimumValue,
      maximumValue: req.body.maximumValue,
      units: req.body.units,
      date: req.body.date,
      status: req.body.status,
      qualityCritical: req.body.qualityCritical,
      safetyCritical: req.body.safetyCritical      
    },
  };
  GlobalUpdate(payload, res);
});

module.exports = router;
